import { NextResponse } from 'next/server';
export const dynamic = 'force-dynamic';

export async function GET() {
  try {
    const COMPANY_ID = process.env.NEXT_PUBLIC_SUMIT_COMPANY_ID || '';
    const API_KEY = process.env.NEXT_PUBLIC_SUMIT_TOKEN || '';
    const API_PUBLIC_KEY = process.env.NEXT_PUBLIC_SUMIT_API_TOKEN || '';
    return NextResponse.json({ COMPANY_ID, API_KEY, API_PUBLIC_KEY });
  } catch (e: any) {
    return NextResponse.json({ error: 'Failed to read env' }, { status: 500 });
  }
}


