import React, { useState } from 'react';
import { useTranslation } from 'react-i18next';
import { managerTabs } from './manager-tabs';
import { managerMenu } from './manager-menu';
import { useAuth } from '../hooks/use-auth';
import ResponsiveTabs from './ResponsiveTabs';
import { MobileNavigation } from './MobileNavigation';
import { ManagerNavigation } from './ManagerNavigation';
import { Menu } from 'lucide-react';
import { useRef } from 'react';

export default function ManagerMainDashboard() {
  const { t } = useTranslation();
  const { user, userRoleId, orderTab } = useAuth();
  // Фильтруем табы по orderTab
  const tabs = managerTabs.filter(tab => tab.id !== 'order' || orderTab !== false);
  // Фильтруем меню по orderTab
  const menu = managerMenu.filter(item => item.id !== 'order' || orderTab !== false);
  const defaultTab = 'dashboard';
  const [activeTab, setActiveTab] = useState(defaultTab);
  const [dropdownOpen, setDropdownOpen] = useState(false);
  const dropdownRef = useRef<HTMLDivElement>(null);

  const ActiveComponent = tabs.find(tab => tab.id === activeTab)?.component;

  return (
    <div className="flex flex-col min-h-screen">
      {/* Navigation */}
      <ManagerNavigation activeTab={activeTab} setActiveTab={setActiveTab} tabs={tabs} menu={menu} />
      {/* Main Content */}
      <main className="flex-1 overflow-x-auto p-1 sm:p-2 md:p-4 pb-20 lg:pb-4">
        {/* Desktop Tabs (only >768px) */}
        <div className="hidden lg:block">
          <div className="flex w-full border-b">
            {tabs.map(tab => (
              <button
                key={tab.id}
                onClick={() => setActiveTab(tab.id)}
                className={`flex-1 px-2 sm:px-4 py-2 sm:py-3 text-center font-medium transition-colors text-sm sm:text-base border-b-2 ${activeTab === tab.id ? 'border-[#549BCE] text-black bg-[#A3D9F2]' : 'text-gray-500 hover:text-blue-600 border-transparent'}`}
              >
                {t(tab.label, tab.label)}
              </button>
            ))}
          </div>
        </div>
        {/* Tab Content */}
        {ActiveComponent && activeTab === 'dashboard' ? (
          <div className="flex justify-center items-start w-full min-h-[60vh] pb-32 sm:pb-32 md:pb-20">
            <div className="w-[95vw] sm:w-[90vw] md:w-[90vw] lg:w-[90vw] xl:w-[90vw] 2xl:w-[90vw] max-w-6xl mx-auto">
              <ActiveComponent />
            </div>
          </div>
        ) : (
          ActiveComponent && <ActiveComponent />
        )}
      </main>
    </div>
  );
} 